//package mpi.ccl;
/****************************************************************************

 MESSAGE PASSING INTERFACE TEST CASE SUITE

 Copyright IBM Corp. 1995

 IBM Corp. hereby grants a non-exclusive license to use, copy, modify, and
 distribute this software for any purpose and without fee provided that the
 above copyright notice and the following paragraphs appear in all copies.

 IBM Corp. makes no representation that the test cases comprising this
 suite are correct or are an accurate representation of any standard.

 In no event shall IBM be liable to any party for direct, indirect, special
 incidental, or consequential damage arising out of the use of this software
 even if IBM Corp. has been advised of the possibility of such damage.

 IBM CORP. SPECIFICALLY DISCLAIMS ANY WARRANTIES INCLUDING, BUT NOT LIMITED
 TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS ON AN "AS IS" BASIS AND IBM
 CORP. HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES,
 ENHANCEMENTS, OR MODIFICATIONS.

****************************************************************************

 These test cases reflect an interpretation of the MPI Standard.  They are
 are, in most cases, unit tests of specific MPI behaviors.  If a user of any
 test case from this set believes that the MPI Standard requires behavior
 different than that implied by the test case we would appreciate feedback.

 Comments may be sent to:
    Richard Treumann
    treumann@kgn.ibm.com

****************************************************************************

 MPI-Java version :
    Sung-Hoon Ko(shko@npac.syr.edu)
    Northeast Parallel Architectures Center at Syracuse University
    03/22/98

****************************************************************************/

import mpi.*;


public class bcast {
  static public void main(String[] args) throws MPIException {
  	
	try{
	bcast b = new bcast(args);
	}catch(Exception e){

	}
	}

  public bcast() {
  }

  public bcast(String[] args) throws Exception {

    final int MAXLEN = 16777216; 
    final int WARM_UP = 5;
    final int REPEAT = 30;
    
    int root,i,k;
    byte out[] = new byte[16777216];
    int myself,tasks;
   // double time;
	int LOG2N_MAX = 1000000,log2nbyte=0;
int j=1;
    MPI.Init(args);
    myself = MPI.COMM_WORLD.Rank();
    tasks = MPI.COMM_WORLD.Size();


    root = 0;//tasks-1;
  
  if(myself == root)
   for(i =0;i < out.length;i++) {
      out[i] = 's';
    }
  
  if(myself == root){
  System.out.println("size\tTimeAvg\tBandwidth MBits/Sec - \tnumProcs\t"+tasks);
  }
  
     /* Logrithmic Loop */
    for (log2nbyte = 0; log2nbyte<= LOG2N_MAX && j<16*1024*1024; ++log2nbyte) { 

   // MPI.COMM_WORLD.Barrier();

	j = (1 << log2nbyte);     
      
      for(i=0;i<WARM_UP;i++) 
	MPI.COMM_WORLD.Bcast(out,0,j,MPI.BYTE,root);
      
      long start = System.nanoTime();
      
      for(i=0;i<REPEAT;i++) 
      MPI.COMM_WORLD.Bcast(out,0,j,MPI.BYTE,root);
      
      long stop = System.nanoTime();
	  double time = (((stop-start)/REPEAT)/(1000.0*1000*1000));
  
   
   double [] reduceIn = new double[1];
   double [] reduceOut = new double[1];
   reduceIn[0] = time;
   
   MPI.COMM_WORLD.Reduce(reduceIn,0,reduceOut,0,1,MPI.DOUBLE,MPI.SUM,root);
	double timeAvg = reduceOut[0]/tasks;
	
   
   MPI.COMM_WORLD.Reduce(reduceIn,0,reduceOut,0,1,MPI.DOUBLE,MPI.MAX,root);
	double timeMAX = reduceOut[0];
	
   MPI.COMM_WORLD.Reduce(reduceIn,0,reduceOut,0,1,MPI.DOUBLE,MPI.MIN,root);
	double timeMIN = reduceOut[0];
	
	double bandwidthAvg =  ( 8*j ) /(timeAvg * 1024*1024);
    MPI.COMM_WORLD.Barrier();
    if(myself == root)  
    //System.out.println("rank\t"+myself+"\tbandwidthAvg (MBits/Sec)\t"+bandwidthAvg+"\ttimeAVG\t"+timeAvg+"\ttimeMIN\t"+timeMIN+"\ttimeMAX\t"+timeMAX+"\tsize\t"+j+"\tnumProcs\t"+tasks);
   System.out.println(j+"\t"+timeAvg+"\t"+bandwidthAvg);

    MPI.COMM_WORLD.Barrier();
    //System.out.println("Bcast TEST COMPLETE");
    
   }
    MPI.Finalize();
  }
}
